##Code from HE (2021)
#Adapated by Jonathan Hambur in April 2022
# Code brings together HR MP changes around announcements

source("https://trimweb.rba.gov.au/record/6808794")
artifactory::setup_artifactory()
install.packages(c("arphit", "chartpackr", "oracle", "rbastattable", "rbatools", "rGertrude", "trim.api"))
install.packages('lubridate')
install.packages('tidyverse')
install.packages('purrr')
install.packages('dplyr')
install.packages('rbastattable')
install.packages('readrba')
install.packages('reshape')
install.packages("writexl")
install.packages("here")
install.packages('jrvFinance')
# Save all MP surprises ---------------------------------------------------
library(rbastattable) # import RBA stat tables (rbaverse package)
library(readrba) # for historical forcasts
library(rbatools)
library(jrvFinance)
library(lubridate)
library(tidyverse)
library(reshape)
library(dplyr)
library(writexl)
#detach("package:here", unload=TRUE)
setwd("//san1/er/Research/JonathanH/Term struct and MP/New working folder/Note replication/Code/Yield data extract/func")
#library(here)
#purrr::map(list.files(path = "//San1/er/Research/JonathanH/Term struct and MP/Note replication/Code/CALVIN shock and var construct/R_calvin", pattern = ".R", full.names = T), source)
source("data-window-extract.R")
source("high-frequency-extraction.R")
source("high-frequency-import-data.R")
source("high-frequency-surprises.R")
setwd("//san1/er/Research/JonathanH/Term struct and MP/New working folder/Note replication/Input data/findur-outputs (not for release)")

# Import and save

# Cahnge here. He seemed to put the pre time in for post and pre, have changed as seemed wrong (confirm) - dont think issue as fixed in the later extract code to be numbers not inputs
ois_changes <- extract_ois(pre = 30, post = 90, open_window = 60) %>%
  select(-`18m`, -`24m`, -`36m`) 

yield_changes <- extract_ags_yield(pre = 30, post = 90, open_window = 60)
cash_rate_lv <-mp_shock_cashrate_level()
cash_rate_ch<- mp_shock_cashrate_change()

cash_rate<-cash_rate_lv %>% left_join(cash_rate_ch) 
cash_rate<- cash_rate %>% mutate(pre=cashrate_level-cashrate_change) 
cash_rate<- cash_rate %>% dplyr::rename(post=cashrate_level)
cash_rate <- cash_rate %>% select(-cashrate_change)
cash_rate <- cash_rate %>% pivot_longer(cols=c("pre", "post"), names_to="names")
rm(cash_rate_lv, cash_rate_ch)

ois_pre<-ois_changes %>% filter(name=="pre") %>% mutate(date = as_date(date_time)) %>% select(-date_time, -value, -name)
ois_post<-ois_changes %>% filter(name=="post") %>% mutate(date = as_date(date_time)) %>% select(-date_time, -value, -name)


yield_details <-yield_changes %>% select(id, coupon, maturity_date) %>% distinct
yield_changes_form<-yield_changes %>% mutate(date = as_date(date_time)) %>% select(date, name, id, yield)
yield_changes_form<-yield_changes_form %>% pivot_wider(id_cols=c("name","date"),names_from =id, values_from=yield)
yield_pre <-yield_changes_form %>% filter(name=="pre") %>% select(-name)
yield_post <-yield_changes_form %>% filter(name=="post") %>% select(-name)

cash_rate_pre<- cash_rate %>% filter(names=="pre") %>% mutate(date = as_date(date_time)) %>% select(-date_time, -names)
cash_rate_post<- cash_rate %>% filter(names=="post") %>% mutate(date = as_date(date_time)) %>% select(-date_time, -names)

write_csv(ois_pre, "/Input data/HF zcr/input/ois_pre.csv")
write_csv(ois_post, "/Input data/HF zcr/input/ois_post.csv")
write_csv(yield_details, "/Input data/HF zcr/input/yield_details.csv")
write_csv(yield_pre, "/Input data/HF zcr/input/yield_pre.csv")
write_csv(yield_post, "/Input data/HF zcr/input/yield_post.csv")
write_csv(cash_rate_pre, "/Input data/HF zcr/input/cash_rate_pre.csv")
write_csv(cash_rate_post, "/Input data/HF zcr/input/cash_rate_post.csv")
